package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.BusinessInfoDto;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.BusinessUserInfoDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteBatchBusinessParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteBatchBusinessUserParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.RemoteBusinessPageParam;

import java.util.List;
import java.util.Set;

/**
 * @Author: nongfu
 * @Date: 2024/2/22-18:03
 * @Description: 商户表 商户用户绑定关系表
 */
@AdvancedFeignClient
public interface RemoteCcbLifeBusinessInfoService {

    //-----------------------------------商户表----------------------------------------------

    /**
     * 分页查询商户信息
     *
     * @param remoteBusinessParam 查询参数
     * @return 数据集合
     */
    List<BusinessInfoDto> selectBusinessByPage(RemoteBusinessPageParam remoteBusinessParam);

    /**
     * 分页查询总数
     *
     * @param remoteBusinessParam 查询参数
     * @return 数据总数
     */
    long selectBusinessCountByPage(RemoteBusinessPageParam remoteBusinessParam);

    /**
     * 插入商户号 存在则更新
     * @param remoteBatchBusinessParamList 批量插入参数
     * @return 插入结果
     */
    Boolean insertOrUpdateBusiness(List<RemoteBatchBusinessParam> remoteBatchBusinessParamList);

    /**
     * 根据商户号查询商户信息
     * @param businessNum
     * @param type 分行来源
     * @return
     */
    BusinessInfoDto getBusiness(String businessNum,Integer type);

    /**
     * 通过商户号批量查询商户信息
     * @param businessNumList
     * @return
     */
    List<BusinessInfoDto> selectBusinessByBusinessNum(Set<String> businessNumList,Integer type);

    //-----------------------------------商户用户绑定关系表----------------------------------------------



     //--------------------------------------------商户用户关联------------------------------------------------
    /**
     * 删除商户用户绑定关系
     * @param businessNum 商户号
     * @param accountId 账户id
     * @return
     */
    Boolean deleteBusinessUser(String businessNum,Long accountId);

    /**
     * 批量插入商户绑定关系
     * @param remoteBatchBusinessParam
     * @return
     */
    Boolean batchInsertBusinessUser(List<RemoteBatchBusinessUserParam> remoteBatchBusinessParam);

    /**
     * 通过账户ID 批量查询商户用户绑定关系
     * @param accountIds
     * @return
     */
    List<BusinessUserInfoDto> queryBusinessUserByAccountIds(List<Long>  accountIds);
    /**
     * 根据商户号查询绑定的商户
     * @param businessNumList
     * @return
     */
    List<BusinessUserInfoDto> queryAccountIdsByBusinessNumList(Set<String> businessNumList);

}
