package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquityCommentDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceEquityCommentSearchParam;
import java.util.List;

/**
 * 保单评论表
 * @author kjj mybatis generator 
 * @date 2024-04-25
 */
@AdvancedFeignClient
public interface RemoteInsuranceEquityCommentService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保单评论集合
     */
    List<InsuranceEquityCommentDto> selectPage(InsuranceEquityCommentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceEquityCommentSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保单评论
     */
    InsuranceEquityCommentDto selectById(Long id);

    /**
     * 新增
     * @param dto 保单评论
     * @return 执行结果
     */
    int insert(InsuranceEquityCommentDto dto);

    /**
     * 更新
     * @param dto 保单评论
     * @return 影响行数
     */
    int update(InsuranceEquityCommentDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}