package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandPaymentInfoDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPaymentInfoSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 需求-付款信息
 * @author kjj mybatis generator
 * @date 2024-10-27
 */
@AdvancedFeignClient
public interface RemoteDemandPaymentInfoService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<DemandPaymentInfoDto> selectPage(DemandPaymentInfoSearchParam param);

    /**
     * 查询总数
     * @param param
     * @return
     */
    long selectCount(DemandPaymentInfoSearchParam param);

    /**
     * 根据需求主键查询
     * @param demandId 需求主键
     * @return 需求-付款信息
     */
    List<DemandPaymentInfoDto> selectByDemandId(Long demandId);


    /**
     * 根据主键查询
     */
    DemandPaymentInfoDto selectById(Long id);

    /**
     * 根据主键查询
     * @param ids 主键
     * @return 需求-付款信息
     */
    List<DemandPaymentInfoDto> selectByIds(Set<Long> ids);

    /**
     * 保存
     */
    long insert(DemandPaymentInfoDto demandPaymentInfoDto);

    /**
     * 更新
     */
    int update(DemandPaymentInfoDto demandPaymentInfoDto);
    /**
     * 完成付款
     * @param demandPaymentInfoDto
     * @return
     */
    Long completePayment(DemandPaymentInfoDto demandPaymentInfoDto);
}
