package cn.com.duiba.quanyi.center.api.dto.ccb.billpush;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 建行账单推送任务 DTO，对应表：tb_ccb_bill_push_task。
 *
 * <p>用于远程接口数据传输，字段与实体保持一致。</p>
 *
 * @author zzy
 * @since 2025-09-25 10:30
 */
@Data
public class CcbBillPushTaskDto implements Serializable {

    private static final long serialVersionUID = 8371265192376502314L;

    /**
     * 推送状态枚举。
     */
    public enum PushStatus {
        /**
         * 已创建。
         */
        CREATED(1),
        /**
         * 生成中。
         */
        GENERATING(2),
        /**
         * 生成完成。
         */
        GENERATED(3),
        /**
         * 推送中。
         */
        PUSHING(4),
        /**
         * 推送完成。
         */
        PUSHED(5);

        private final Integer value;

        PushStatus(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 主键ID。
     */
    private Long id;

    /**
     * 结算单ID。对应字段：settlement_id。
     */
    private Long settlementId;

    /**
     * 需求ID。对应字段：demand_id。
     */
    private Long demandId;

    /**
     * 结算周期。对应字段：settlement_cycle。
     */
    private String settlementCycle;

    /**
     * 账单文件数量。对应字段：bill_file_count。
     */
    private Integer billFileCount;

    /**
     * 推送状态：已创建-1、生成中-2、生成完成-3、推送中-4、推送完成-5。对应字段：push_status。
     */
    private Integer pushStatus;

    /**
     * 推送时间。对应字段：push_time。
     */
    private Date pushTime;

    /**
     * 启用状态：0-停止、1-启用。对应字段：enable_status。
     */
    private Integer enableStatus;

    /**
     * 创建人SSOID。对应字段：creator_ssoid。
     */
    private Long creatorSsoId;

    /**
     * 创建人名称。对应字段：creator_name。
     */
    private String creatorName;

    /**
     * 创建时间。对应字段：gmt_create。
     */
    private Date gmtCreate;

    /**
     * 修改时间。对应字段：gmt_modified。
     */
    private Date gmtModified;
}


