package cn.com.duiba.quanyi.center.api.remoteservice.user;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtApiDto;

/**
 * 用户信息扩展表- API供货
 * @author kjj mybatis generator 
 * @date 2024-07-03
 */
@AdvancedFeignClient
public interface RemoteUserExtApiService {

    /**
     * 新增或修改
     *
     * @param dto 用户扩展信息
     * @param forceBinding 是否强制绑定
     * @return 主键
     */
    BaseResultDto<Long> saveOrUpdate(UserExtApiDto dto, boolean forceBinding);

    /**
     * 根据用户ID查询
     *
     * @param userId 用户ID
     * @return 用户信息扩展- API供货
     */
    UserExtApiDto selectByUserId(Long userId);

    /**
     * 根据uid查询
     *
     * @param uid uid
     * @return 用户信息扩展- API供货
     */
    List<UserExtApiDto> selectByUid(String uid);

    /**
     * 根据thirdOrderId查询
     *
     * @param thirdOrderId thirdOrderId
     * @return 用户信息扩展- API供货
     */
    List<UserExtApiDto> selectByThirdOrderId(String thirdOrderId);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 用户信息扩展- API供货
     */
    UserExtApiDto selectById(Long id);

    /**
     * 根据主键物理删除(目前是只有管理后台可以使用，其他的勿用！！！)
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}