package cn.com.duiba.quanyi.center.api.param.pkg;

import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 商品包支付创建订单参数
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class GoodsPkgPayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 商品包sku主键
     */
    private Long pkgSkuId;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 用户ip
     */
    @Deprecated
    private String userIp;

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;
}
