package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 账单推送数据-批次维度
 * @author mybatis generator 
 * @date 2024-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillPushStockSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17098776071487187L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 账单id
     */
    private Long billId;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 统计日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 卡券有效期
     */
    private Integer validityPeriod;

    /**
     * 单个用户最多可领个数
     */
    private Integer maxCouponsPerUser;

    /**
     * 批次名称
     */
    private String stockName;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 总库存
     */
    private Long totalNum;

    /**
     * 已发放数量
     */
    private Long distributedNum;

    /**
     * 总预算，单位分
     */
    private Long maxAmount;

    /**
     * 发放进度 发放数量/总数 10%存成1000
     */
    private Integer distributedProgress;

    /**
     * 发放金额
     */
    private Long distributedAmount;

    /**
     * 核销金额
     */
    private Long writeOffAmount;

    /**
     * 核销笔数
     */
    private Integer writeOffNum;

    /**
     * 退款核销金额 分
     */
    private Long refundWriteOffAmount;

    /**
     * 退款核销笔数
     */
    private Integer refundWriteOffNum;

    /**
     * 剩余笔数 总库存-发放数量
     */
    private Integer surplusNum;

    /**
     * 剩余金额
     */
    private Integer surplusAmount;

    /**
     * 实际核销金额 分
     */
    private Long realWriteOffAmount;

    /**
     * 实际核销笔数
     */
    private Integer realWriteOffNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}