package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeScheduledExecutionStatusEnum;
import lombok.Data;

/**
 * 活动奖品定时任务表
 * @author mybatis generator
 * @date 2025-05-27
 */
@Data
public class ActivityPrizeScheduledTaskDto implements Serializable {

    private static final long serialVersionUID = 17483442164814989L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 执行时间
     */
    private Date executionTime;

    /**
     * 业务类型，1-库存
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeScheduledTaskBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务规则，1-替换，2-新增，3-删除
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeScheduledTaskBizRuleEnum
     */
    private Integer bizRule;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 业务类型数据
     */
    private String bizData;
    /**
     * 逻辑删除，0-正常，1-删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;


    /**
     * 执行状态
     * @see ActivityPrizeScheduledExecutionStatusEnum
     */
    private Integer executionStatus;

    /**
     * 错误信息
     */
    private String errorMsg;
}
