package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:06
 */
@Getter
@AllArgsConstructor
public enum InsuranceAccountStatusEnum {
    ENABLE(1, "启用"),
    DISABLED(0, "禁用"),
    LOCKING(2, "锁定"),
    ;
    
    private final Integer type;
    
    private final String desc;

    private static final Map<Integer, InsuranceAccountStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceAccountStatusEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceAccountStatusEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
