package cn.com.duiba.quanyi.center.api.remoteservice.template;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.template.TemplateContentDto;
import cn.com.duiba.quanyi.center.api.param.template.TemplateCodeSearchParam;
import cn.com.duiba.quanyi.center.api.param.template.TemplateContentSearchParam;
import com.alibaba.fastjson.JSONArray;

import java.util.List;

/**
 * 模板内容表
 * 
 * @author kjj mybatis generator
 * @date 2025-03-25
 */
@AdvancedFeignClient
public interface RemoteTemplateContentService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * 
     * @param param 查询条件
     * @return 模板内容集合
     */
    List<String> selectPage(TemplateContentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * 
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TemplateContentSearchParam param);

    /**
     * 根据主键查询
     * 
     * @param id 主键
     * @return 模板内容
     */
    TemplateContentDto selectById(Long id);

    /**
     * 保存或更新模板内容
     *
     * @param dto 保存参数
     * @return 内容ID
     */
    Long saveOrUpdateTemplateContent(TemplateContentDto dto);

    /**
     * 物理删除
     * 
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 逻辑删除
     *
     * @param recordNo 记录号
     * @return 执行结果
     */
    int deleteByRecordNo(String recordNo);

    /**
     * 根据记录编号列表查询模板内容列表
     * 
     * @param recordNoList 记录编号列表
     * @return 模板内容列表
     */
    List<TemplateContentDto> listByRecordNoList(List<String> recordNoList);

    /**
     * 按模板code查询
     *
     * @param param 参数
     * @return {@link JSONArray }
     */
    JSONArray getJsonArray(TemplateCodeSearchParam param);
}