package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/9/20 11:16
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderSwitchEnum {

    SHORT_TRANSFER_IS_DETAIL(0, "短链中转页是订单详情页面"),
    PSBC_PUSHED_SUB_STATUS_MARK(1, "邮储卡中心已推送子券状态标记"),
    HAS_REISSUE(2, "是否有补发订单"),
    IS_REISSUE(3, "是否是补发订单"),
    API_ONLY_PUSH_VERIFICATION_OR_EXPIRED(4, "API供货仅推送核销和过期"),
    HAS_PAY_ORDER(5, "是否关联了支付订单号"),
    ;

    /**
     * 在二进制中的位置（从右往左第几位，从0开始）
     */
    private final Integer position;

    /**
     * 描述
     */
    private final String desc;
}
