/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.settlement;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum InvoiceStatusEnum {
    PENDING_INVOICING(1, "\u5f85\u5f00\u7968"),
    INVOICED(2, "\u5df2\u5f00\u7968"),
    INVOICE_RED_OFFSET_APPROVAL(3, "\u7ea2\u51b2\u5ba1\u6279\u4e2d"),
    INVOICE_RED_OFFSET(4, "\u5df2\u7ea2\u51b2");

    private static final Map<Integer, InvoiceStatusEnum> ENUM_MAP;
    private final Integer status;
    private final String desc;

    public static InvoiceStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

    private InvoiceStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(InvoiceStatusEnum.values()).collect(Collectors.toMap(InvoiceStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    }
}

