package cn.com.duiba.quanyi.center.api.remoteservice.insurance.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyStatDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.login.InsuranceLoginAccountDto;

import java.util.List;

/**
 * 保险公司统计数据
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceCompanyStatService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保险公司统计数据
     */
    InsuranceCompanyStatDto selectById(Long id);

    /**
     * 根据公司ID列表，查询统计数据
     * @param companyIds
     * @return
     */
    List<InsuranceCompanyStatDto> selectByCompanyIds(List<Long> companyIds);


    /**
     * 根据公司ID，查询统计数据
     * @param companyId
     * @return
     */
    InsuranceCompanyStatDto selectByCompanyId(Long companyId);


    /**
     * 新增
     * @param dto 查询统计数据
     * @return 执行结果
     */
    int insert(InsuranceCompanyStatDto dto);


    /**
     * 更新查询统计数据
     * @param dto 查询统计数据
     * @return 执行结果
     */
    int update(InsuranceCompanyStatDto dto);

}