package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代表在周期时间范围下，子周期限定时间类型
 * SECOND_OF_DAY:一天内具体时间点(秒为单位)
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipaySubCyclePeriodTypeEnum {
    SECOND_OF_DAY("SECOND_OF_DAY", "一天内具体时间点"),
    ;

    private final String type;

    private final String desc;
}
