package cn.com.duiba.quanyi.center.api.param.product;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 数字营销产品
 * @author mybatis generator 
 * @date 2025-06-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ProductSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17496341567625615L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 产品类型 1-标准产品 2-定制产品
     */
    private Integer productType;

    /**
     * 启用状态 1-启用 0-停用
     */
    private Integer enableStatus;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;
}