package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandOccupyDto;

import java.util.List;
import java.util.Set;

/**
 * 需求占用表
 *
 * @author xuzhigang
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemoteDemandOccupyService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 需求占用记录
     */
    DemandOccupyDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 需求占用记录列表
     */
    List<DemandOccupyDto> selectByIdList(Set<Long> ids);

    /**
     * 根据需求ID查询
     *
     * @param demandId 需求ID
     * @return 需求占用记录
     */
    DemandOccupyDto selectByDemandId(Long demandId);

    /**
     * 根据需求ID批量查询
     *
     * @param demandIds 需求ID集合
     * @return 需求占用记录列表
     */
    List<DemandOccupyDto> selectByDemandIdList(List<Long> demandIds);

    /**
     * 新增
     *
     * @param dto 需求占用记录
     * @return 主键ID
     */
    Long insert(DemandOccupyDto dto);

    /**
     * 更新
     *
     * @param dto 需求占用记录
     * @return 执行结果
     */
    int update(DemandOccupyDto dto);

    /**
     * 更新占用金额
     *
     * @param demandId 需求ID
     * @param occupyAmount 占用金额
     * @return 执行结果
     */
    int updateOccupyAmount(Long demandId, Long occupyAmount);

    /**
     * 更新结算金额
     *
     * @param demandId 需求ID
     * @param settlementAmount 结算金额
     * @return 执行结果
     */
    int updateSettlementAmount(Long demandId, Long settlementAmount);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
} 