package cn.com.duiba.quanyi.center.api.dto.api;

import cn.com.duiba.quanyi.center.api.enums.api.ApiActivityTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 多选一关联API供货
 * @Author cuizhoujian
 * @Date 2025-03-17 17:45:05
 */
@Data
public class MultiRelateActivityConfigDto implements Serializable {
    private static final long serialVersionUID = 6653463535951716128L;

    /**
     * 关联活动id
     */
    private Long activityId;

    /**
     * 活动发放方式，1-单品，2-券包
     *
     * @see ApiActivityTypeEnum#getType()
     */
    private Integer apiActivityType;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 商品名称
     */
    private String prizeName;

    /**
     * API集合展示图
     */
    private String pageImg;

    /**
     * 无库存不可领取
     */
    private Integer stockLimit;

    /**
     * 奖品id
     */
    private Long prizeId;

    /**
     * 商品库spu类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum#getType()
     */
    private Integer spuType;
}
