package cn.com.duiba.quanyi.center.api.dto.qy.activitystockwarn;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 活动库存告警配置表
 * @author mybatis generator 
 * @date 2024-02-04
 */
@Data
public class ActivityStockWarnConfigDto implements Serializable {
     
    private static final long serialVersionUID = 17070183801447018L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型,1-白名单领奖,2-兑吧卡密包,7-API供货
     */
    private Integer activityType;

    /**
     * 是否开启,0-关闭,1-开启
     */
    private Boolean enable;

    /**
     * 比例
     */
    private String proportion;

    /**
     * 绝对值
     */
    private Integer absoluteValue;

    /**
     * 钉钉token
     */
    private String dingDingToken;

    /**
     * 奖品ID，默认值0
     */
    private Long prizeId;

    /**
     * 告警类型，1-活动库存告警，2-奖品库存告警
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityStockWarnTypeEnum
     */
    private Integer warnType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}