/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils;

import cn.com.duiba.quanyi.center.api.dto.activity.ClaimTimeLimitDto;
import cn.com.duiba.quanyi.center.api.enums.activity.ClaimTimeLimitTypeEnum;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimTimeLimitValidatorUtils {
    private static final Logger log = LoggerFactory.getLogger(ClaimTimeLimitValidatorUtils.class);
    private static final String CLAIM_TIME_OUT_MESSAGE = "\u5bf9\u4e0d\u8d77\uff0c\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u4f7f\u7528\u65f6\u95f4\u8303\u56f4\u5185\uff01";

    public static boolean isValidClaimTime(ClaimTimeLimitDto claimTimeLimitDto, Date orderCreateTime) {
        if (claimTimeLimitDto == null || claimTimeLimitDto.getLimitType() == null) {
            return true;
        }
        ClaimTimeLimitTypeEnum limitType = ClaimTimeLimitTypeEnum.getByType(claimTimeLimitDto.getLimitType());
        if (limitType == null || limitType == ClaimTimeLimitTypeEnum.NO_LIMIT) {
            return true;
        }
        Date currentTime = new Date();
        try {
            switch (limitType) {
                case LATEST_CLAIM_TIME: {
                    return ClaimTimeLimitValidatorUtils.validateLatestClaimTime(claimTimeLimitDto.getLatestClaimTime(), currentTime);
                }
                case DAYS_AFTER_ORDER: {
                    return ClaimTimeLimitValidatorUtils.validateDaysAfterOrder(claimTimeLimitDto.getDaysAfterOrder(), orderCreateTime, currentTime);
                }
                case MONTH_DAY_AFTER_ORDER: {
                    return ClaimTimeLimitValidatorUtils.validateMonthDayAfterOrder(claimTimeLimitDto.getMonthDayAfterOrder(), orderCreateTime, currentTime);
                }
                case QUARTER_AFTER_ORDER: {
                    return ClaimTimeLimitValidatorUtils.validateQuarterAfterOrder(orderCreateTime, currentTime);
                }
                case CUSTOM_TIME: {
                    return ClaimTimeLimitValidatorUtils.validateCustomTime(claimTimeLimitDto.getCustomStartTime(), claimTimeLimitDto.getCustomEndTime(), currentTime);
                }
            }
            log.warn("\u672a\u77e5\u7684\u9886\u53d6\u65f6\u95f4\u9650\u5236\u7c7b\u578b: {}", (Object)claimTimeLimitDto.getLimitType());
            return true;
        }
        catch (Exception e) {
            log.error("\u9886\u53d6\u65f6\u95f4\u6821\u9a8c\u5f02\u5e38, claimTimeLimitDto: {}, currentTime: {}", new Object[]{claimTimeLimitDto, currentTime, e});
            return true;
        }
    }

    private static boolean validateLatestClaimTime(Date latestClaimTime, Date currentTime) {
        if (latestClaimTime == null) {
            return true;
        }
        return !currentTime.after(latestClaimTime);
    }

    private static boolean validateDaysAfterOrder(Integer daysAfterOrder, Date orderCreateTime, Date currentTime) {
        if (daysAfterOrder == null || orderCreateTime == null) {
            return true;
        }
        Date deadline = DateUtils.addDays((Date)orderCreateTime, (int)daysAfterOrder);
        return !currentTime.before(orderCreateTime) && !currentTime.after(deadline);
    }

    private static boolean validateMonthDayAfterOrder(Integer monthDayAfterOrder, Date orderCreateTime, Date currentTime) {
        if (monthDayAfterOrder == null || orderCreateTime == null) {
            return true;
        }
        if (currentTime.before(orderCreateTime)) {
            return false;
        }
        Calendar orderCal = Calendar.getInstance();
        orderCal.setTime(orderCreateTime);
        int orderYear = orderCal.get(1);
        int orderMonth = orderCal.get(2);
        Calendar currentCal = Calendar.getInstance();
        currentCal.setTime(currentTime);
        int currentYear = currentCal.get(1);
        int currentMonth = currentCal.get(2);
        int currentDay = currentCal.get(5);
        if (orderYear == currentYear && orderMonth == currentMonth) {
            return currentDay <= monthDayAfterOrder;
        }
        return false;
    }

    private static boolean validateQuarterAfterOrder(Date orderCreateTime, Date currentTime) {
        if (orderCreateTime == null) {
            return true;
        }
        if (currentTime.before(orderCreateTime)) {
            return false;
        }
        Calendar orderCal = Calendar.getInstance();
        orderCal.setTime(orderCreateTime);
        int orderYear = orderCal.get(1);
        int orderQuarter = ClaimTimeLimitValidatorUtils.getQuarter(orderCal.get(2));
        Calendar currentCal = Calendar.getInstance();
        currentCal.setTime(currentTime);
        int currentYear = currentCal.get(1);
        int currentQuarter = ClaimTimeLimitValidatorUtils.getQuarter(currentCal.get(2));
        return orderYear == currentYear && orderQuarter == currentQuarter;
    }

    private static int getQuarter(int month) {
        return month / 3 + 1;
    }

    private static boolean validateCustomTime(Date customStartTime, Date customEndTime, Date currentTime) {
        if (customStartTime == null || customEndTime == null) {
            return true;
        }
        return !currentTime.before(customStartTime) && !currentTime.after(customEndTime);
    }

    public static String getErrorMessage() {
        return CLAIM_TIME_OUT_MESSAGE;
    }
}

