package cn.com.duiba.quanyi.center.api.remoteservice.qy.bill.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.bill.coupon.WxCouponBillDownloadRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.bill.coupon.WxCouponBillDownloadRecordSearchParam;
import java.util.List;

/**
 * 微信账单数据下载记录表
 * @author kjj mybatis generator 
 * @date 2024-02-28
 */
@AdvancedFeignClient
public interface RemoteWxCouponBillDownloadRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信账单数据下载记录集合
     */
    List<WxCouponBillDownloadRecordDto> selectPage(WxCouponBillDownloadRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxCouponBillDownloadRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信账单数据下载记录
     */
    WxCouponBillDownloadRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信账单数据下载记录
     * @return 主键id 插入失败则返回null
     */
    Long insert(WxCouponBillDownloadRecordDto dto);

    /**
     * 更新
     * @param dto 微信账单数据下载记录
     * @return 影响行数
     */
    int update(WxCouponBillDownloadRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}