package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * CREDIT:信用卡
 * DEBIT:借记卡
 * DEBIT_CREDIT:借记卡或信用卡
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipayBankCardTypeEnum {
    CREDIT("CREDIT", "信用卡"),
    DEBIT("DEBIT", "借记卡"),
    DEBIT_CREDIT("DEBIT_CREDIT", "借记卡或信用卡"),
    ;

    private final String type;

    private final String desc;

    private static final Map<String, AlipayBankCardTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(AlipayBankCardTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static AlipayBankCardTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
