package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceExternalDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceExternalSearchParam;

import java.util.List;

/**
 * 外部发票表远程服务
 * @author xuzhigang
 * @date 2025-01-21
 */
@AdvancedFeignClient
public interface RemoteInvoiceExternalService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 发票信息
     */
    InvoiceExternalDto selectById(Long id);

    /**
     * 根据创建人ID查询
     * @param createOperatorId 创建人ID
     * @return 发票信息列表
     */
    List<InvoiceExternalDto> selectByCreateOperatorId(Long createOperatorId);

    /**
     * 根据主键ID集合批量查询
     * @param ids 主键ID集合
     * @return 发票信息列表
     */
    List<InvoiceExternalDto> selectByIds(List<Long> ids);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 发票信息列表
     */
    List<InvoiceExternalDto> selectPage(InvoiceExternalSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    long selectCount(InvoiceExternalSearchParam param);

    /**
     * 保存或更新
     * @param dto 发票信息
     * @return 主键
     */
    Long saveOrUpdate(InvoiceExternalDto dto);

    /**
     * 更新
     * @param dto 发票信息
     * @return 影响行数
     */
    int update(InvoiceExternalDto dto);

    /**
     * 解除关联
     * @param invoiceId 发票ID
     * @param bizId 业务ID
     * @param bizType 业务类型
     * @return 执行结果
     */
    int disassociation(Long invoiceId, Long bizId, Integer bizType);
}
