package cn.com.duiba.quanyi.center.api.param.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuzhigang
 * @date 2025/9/26 17:50
 **/
@Data
public class PaymentInfoSupplierListParam implements Serializable {
    private static final long serialVersionUID = -7649161838516526307L;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 付款状态
     * @see cn.com.duiba.quanyi.center.api.enums.payment.SupplierPaymentStatusEnum
     */
    private Integer paymentStatus;

    /**
     * 供应商付款编号
     */
    private String supplierPaymentNo;

    /**
     * 审批发起时间开始时间
     */
    private Date approvalStartTimeStart;

    /**
     * 审批发起时间结束时间
     */
    private Date approvalStartTimeEnd;


    /**
     * 审批结束时间开始时间
     */
    private Date approvalEndTimeStart;

    /**
     * 审批结束时间结束时间
     */
    private Date approvalEndTimeEnd;
}
