package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.VerifyNotifyBatchRelationDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.VerifyNotifyDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.VerifyNotifyStockCntDto;
import cn.com.duiba.quanyi.center.api.param.coupon.VerifyNotifyBatchRelationSearchParam;
import java.util.List;

/**
 * 核销通知与批次关联表
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteVerifyNotifyBatchRelationService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 核销通知与批次关联集合
     */
    List<VerifyNotifyBatchRelationDto> selectPage(VerifyNotifyBatchRelationSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(VerifyNotifyBatchRelationSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 核销通知与批次关联
     */
    VerifyNotifyBatchRelationDto selectById(Long id);

    /**
     * 新增
     * @param dto 核销通知与批次关联
     * @return 执行结果
     */
    Long insert(VerifyNotifyBatchRelationDto dto);

    /**
     * 更新
     * @param dto 核销通知与批次关联
     * @return 影响行数
     */
    int update(VerifyNotifyBatchRelationDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 统计关联批次类型统计数量
     * @param ids
     * @return
     */
    List<VerifyNotifyStockCntDto> selectCountGroupByStockType(List<Long> ids);

    /**
     * 根据批次ID跟批次类型查询核销通知对象
     * @param stockType
     * @param stockId
     * @return
     */
    VerifyNotifyDto queryVerifyNotifyByStockIdAndType(Integer stockType, String stockId);

    /**
     * 根据核销通知ID查询关联关系集合
     *
     * @param verifyNotifyId 核销通知ID
     * @return 核销通知与批次关联集合
     */
    List<VerifyNotifyBatchRelationDto> selectByVerifyNotifyId(Long verifyNotifyId);
}