package cn.com.duiba.quanyi.center.api.dto.demand;

import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/11/12 14:35
 **/
@Data
public class DigitalDemandGoodsDto implements Serializable {
    private static final long serialVersionUID = -4070310284422222751L;

    /**
     * 主键，编辑时传入
     */
    private Long id;

    /**
     * 面额类型：1-固定，2-不固定
     * @see AmountTypeEnum#getType()
     */
    private Integer amountType = AmountTypeEnum.FIXED.getType();

    /**
     * 面额，单位分（固定面额时必填）
     */
    private Long amount;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;


    /**
     * 备注
     */
    private String remark;

    /**
     * 商品数量
     * 如果有数量，最大不超过999999
     */
    private Long quantity;

    /**
     * 消耗预算
     */
    private Long consumeBudget;

    /**
     * 占用合同金额
     */
    private Long occupyContractAmount;

    /**
     * 发票类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.invoice.InvoiceTypeEnum
     */
    private Integer invoiceType;

    /**
     * 结算费率，百分数，支持小数点
     */
    private String settlementRate;

    /**
     * 售价
     */
    private Long settlementPrice;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 采购商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuTypeEnum#getType()
     */
    private Integer purchaseSpuType;

    /**
     * 结算方式，1.按核销结算,2.按订单交易成功,3.按采购结算
     * @see cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum#getType()
     */
    private Integer settlementMethod;
}
