package cn.com.duiba.quanyi.center.api.dto.deposit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 保证金表
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
public class PaymentInfoDepositDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;



    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 保证金id tb_demand_paymnet_info.id
     */
    private Long paymentInfoId;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 投标名称，最多20字
     */
    private String bidName;

    /**
     * 开标日期
     */
    private Date biddingDate;

    /**
     * 预计回款日期，不能早于当前日期
     */
    private Date expectedReceivedDate;

    /**
     * 招标文件存储URL
     */
    private String biddingFileUrl;

    /**
     * 保证金状态 1-发起中，2-发起失败 3-审批中，4-审核拒绝，5-审批成功（待回款），6-部分回款，7-已回款
     */
    private Integer depositStatus;

    /**
     * 回款金额
     */
    private Long receivedAmount;

    /**
     * 已占用回款金额
     */
    private Long occupyReceivedAmount;

    /**
     * 关联合同id
     */
    private Long relatedContractId;
}
