package cn.com.duiba.quanyi.center.api.dto.contract;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 合同消耗统计DTO
 *
 * @author xuzhigang
 * @date 2025-06-06
 */
@Data
public class ContractConsumeStatDto implements Serializable {

    private static final long serialVersionUID = 734567890123456780L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计ID
     */
    private Long statId;

    /**
     * 统计维度 1-合同 2-项目
     */
    private Integer statType;

    /**
     * 合同金额
     */
    private Long contractAmount;

    /**
     * 占用金额
     */
    private Long occupyAmount;

    /**
     * 消耗金额
     */
    private Long consumeAmount;

    /**
     * 是否超额 0-未超额 1-已超额
     */
    private Integer hasOverAmount;

    /**
     * 版本号（乐观锁版本控制）
     */
    private Integer lockVersion;

    /**
     * 权益合同金额
     */
    private Long quanyiContractAmount;
} 