package cn.com.duiba.quanyi.center.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.cardsecret.CardSecretRefundTaskDetailDto;

/**
 * 卡密回退任务明细远程服务接口
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@AdvancedFeignClient
public interface RemoteCardSecretRefundTaskDetailService {

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return 卡密回退任务明细
     */
    CardSecretRefundTaskDetailDto selectById(Long id);

    /**
     * 根据批次号查询明细列表
     *
     * @param batchId 批次号
     * @return 明细列表
     */
    List<CardSecretRefundTaskDetailDto> selectByBatchId(Long batchId);

    /**
     * 根据任务ID查询明细列表
     * 注意：此方法没有对应的索引，会进行全表扫描，性能较差，仅用于审批流等低频场景
     *
     * @param taskId 任务ID
     * @return 明细列表
     */
    List<CardSecretRefundTaskDetailDto> selectByTaskId(Long taskId);

    /**
     * 插入卡密回退任务明细
     *
     * @param dto 卡密回退任务明细DTO
     * @return 明细ID
     */
    Long insert(CardSecretRefundTaskDetailDto dto);

    /**
     * 批量插入卡密回退任务明细
     *
     * @param dtos 明细列表
     * @return 影响行数
     */
    int batchInsert(List<CardSecretRefundTaskDetailDto> dtos);

    /**
     * 更新卡密回退任务明细
     *
     * @param dto 卡密回退任务明细DTO
     * @return 影响行数
     */
    int update(CardSecretRefundTaskDetailDto dto);

    /**
     * 更新最终回退数量
     *
     * @param id 明细ID
     * @param finalRefundNum 最终回退数量
     * @return 影响行数
     */
    int updateFinalRefundNum(Long id, Long finalRefundNum);
}

