package cn.com.duiba.quanyi.center.api.remoteservice.workflow;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.workflow.WorkflowInstanceDto;

import java.util.List;


/**
 * 审批流记录
 * @author kjj mybatis generator 
 * @date 2024-10-21
 */
@AdvancedFeignClient
public interface RemoteWorkflowInstanceService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 审批流记录
     */
    WorkflowInstanceDto selectById(Long id);

    /**
     * 根据业务ID查询
     * @param bizId 业务ID
     * @param workflowType 审批流类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     * @return 审批流记录
     */
    WorkflowInstanceDto selectLastByBizId(Long bizId, Integer workflowType);

    /**
     * 根据业务ID集合和审批流类型查询运行中的审批实例
     * @param bizIds 业务ID集合
     * @param workflowType 审批流类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     * @return 运行中的审批流记录列表
     */
    List<WorkflowInstanceDto> queryRunningInstancesByBizIdsAndWorkflowType(List<Long> bizIds, Integer workflowType);
}