package cn.com.duiba.quanyi.center.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.cardsecret.CardSecretRefundTaskDto;
import cn.com.duiba.quanyi.center.api.param.cardsecret.CardSecretRefundTaskPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.cardsecret.CardSecretStartRefundParam;

/**
 * 卡密回退任务远程服务接口
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@AdvancedFeignClient
public interface RemoteCardSecretRefundTaskService {

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return 卡密回退任务
     */
    CardSecretRefundTaskDto selectById(Long id);

    /**
     * 根据需求商品ID查询任务列表
     *
     * @param demandGoodsId 需求商品ID
     * @return 任务列表
     */
    List<CardSecretRefundTaskDto> selectByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据审批流程实例ID查询
     *
     * @param workflowInstanceId 审批流程实例ID
     * @return 卡密回退任务
     */
    CardSecretRefundTaskDto selectByWorkflowInstanceId(Long workflowInstanceId);

    /**
     * 插入卡密回退任务
     *
     * @param dto 卡密回退任务DTO
     * @return 任务ID
     */
    Long insert(CardSecretRefundTaskDto dto);

    /**
     * 更新卡密回退任务
     *
     * @param dto 卡密回退任务DTO
     * @return 影响行数
     */
    int update(CardSecretRefundTaskDto dto);

    /**
     * 更新已回退数量（从明细汇总）
     *
     * @param taskId 任务ID
     * @return 影响行数
     */
    int updateRefundedNum(Long taskId);

    /**
     * 更新任务状态（带乐观锁）
     *
     * @param id 任务ID
     * @param fromStatus 期望的原始状态
     * @param toStatus 目标状态
     * @return 影响行数
     */
    int updateTaskStatus(Long id, Integer fromStatus, Integer toStatus);

    /**
     * 批量回退卡密(走审批流)
     *
     * @param param 卡密回退参数
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean startRefundWithSettled(CardSecretStartRefundParam param) throws BizException;

    /**
     * 分页查询
     *
     * @param param 分页查询参数
     * @return 卡密回退任务列表
     */
    List<CardSecretRefundTaskDto> selectPage(CardSecretRefundTaskPageQueryParam param);

    /**
     * 统计数量
     *
     * @param param 分页查询参数
     * @return 数量
     */
    Integer count(CardSecretRefundTaskPageQueryParam param);
}

