package cn.com.duiba.quanyi.center.api.enums.api;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/9/3 11:29
 */
@Getter
@AllArgsConstructor
public enum ApiUidBindTypeEnum {
    WX_OPEN_ID(1, "微信openId"),
    ALIPAY_OPEN_ID(2, "支付宝openId"),
    ALIPAY_USER_ID(3, "支付宝userId"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, ApiUidBindTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ApiUidBindTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static ApiUidBindTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
