package cn.com.duiba.quanyi.center.api.remoteservice.unionpay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.unionpay.UnionPayActivityStockDto;
import cn.com.duiba.quanyi.center.api.param.unionpay.UnionPayActivityStockSearchParam;
import java.util.List;

/**
 * 银联卡卷库存表
 * @author kjj mybatis generator 
 * @date 2025-04-23
 */
@AdvancedFeignClient
public interface RemoteUnionPayActivityStockService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 银联卡卷库存集合
     */
    List<UnionPayActivityStockDto> selectPage(UnionPayActivityStockSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UnionPayActivityStockSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联卡卷库存
     */
    UnionPayActivityStockDto selectById(Long id);


    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param unionPayActivityIds 查询条件
     * @return 银联卡卷库存集合
     */
    List<UnionPayActivityStockDto> selectByUnionPayActivityIds(List<Long> unionPayActivityIds);

    /**
     * 新增
     * @param dto 银联卡卷库存
     * @return 执行结果
     */
    int insert(UnionPayActivityStockDto dto);

    /**
     * 更新
     * @param dto 银联卡卷库存
     * @return 影响行数
     */
    int update(UnionPayActivityStockDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}