package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceTakeRecordDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceTakeRecordSumStatisticsDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceStatisticsSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 保司兑换记录表
 * @author kjj mybatis generator
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeRecordService {

    /**
     * 当日已领取金额
     * @param accountPhone 手机号
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return 金额
     */
    long sumDayAmount(String accountPhone, Integer spuType, Date now);

    /**
     * 当月已领取金额
     * @param accountPhone 手机号
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return 金额
     */
    long sumMonthAmount(String accountPhone, Integer spuType, Date now);

    /**
     * 当日已领取金额
     * @param accountPhone 手机号
     * @param spuTypes 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return key：商品类型，value：金额
     */
    Map<Integer, Long> sumDayAmountMap(String accountPhone, Set<Integer> spuTypes, Date now);

    /**
     * 当月已领取金额
     * @param accountPhone 手机号
     * @param spuTypes 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @param now 当前时间
     * @return key：商品类型，value：金额
     */
    Map<Integer, Long> sumMonthAmountMap(String accountPhone, Set<Integer> spuTypes, Date now);

    /**
     * 分页查询兑换记录
     * @param lastId 上一页id，第一页不传
     * @param pageSize 分页大小
     * @param companyId 公司id
     * @param spuType 商品类型
     * @param userId 用户id
     * @return
     */
    List<InsuranceTakeRecordDto> selectByOffset(Long lastId, Integer pageSize, Long companyId, Integer spuType, Long userId);

    /**
     * 分页查询
     * @param lastId 最后一页id 第一页不传
     * @param pageSize 分页大小
     * @param companyId 公司id
     * @param spuType 商品类型
     * @param accountPhone 手机号
     * @return 保司兑换记录列表
     */
    List<InsuranceTakeRecordDto> selectByPhoneOffset(Long lastId, Integer pageSize, Long companyId, Integer spuType, String accountPhone);

    /**
     * 统计总消耗积分
     * @param accountPhone 手机号
     * @param companyId 公司ID
     * @param takeBizType 业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceTakeBizTypeEnum
     * @param spuType 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     * @return 总消耗积分
     */
    long sumByPhoneCompanyIdType(String accountPhone, Long companyId, Integer takeBizType, Integer spuType);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    InsuranceTakeRecordDto selectById(Long id);


    /**
     * 根据订单号查询
     * @param takeOrderNo
     * @return
     */
    InsuranceTakeRecordDto selectByTakeOrderNo(String takeOrderNo);

    /**
     * 根据订单号批量查询
     * @param takeOrderNos 订单号集合
     * @return 兑换记录结果集
     */
    List<InsuranceTakeRecordDto> selectByTakeOrderNos(List<String> takeOrderNos);

    /**
     * 根据Spu与BizType进行汇总统计
     * @return
     */
    List<InsuranceTakeRecordSumStatisticsDto> selectSumBySpuAndBizType(InsuranceStatisticsSearchParam param);

    /**
     * 根据id集合批量查询
     *
     * @param ids id集合
     * @return 兑换记录
     */
    List<InsuranceTakeRecordDto> selectByIds(Set<Long> ids);

    /**
     * 根据退款订单号批量查询
     * @param refundOrderNos 订单号集合
     * @return 兑换记录结果集
     */
    List<InsuranceTakeRecordDto> selectByRefundOrderNos(List<String> refundOrderNos);


    /**
     * 根据支付订单号批量查询
     * @param takeBizNos 订单号集合
     * @return 兑换记录结果集
     */
    List<InsuranceTakeRecordDto> selectByTakeBizNos(List<String> takeBizNos);
}
