package cn.com.duiba.quanyi.center.api.dto.login;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/7/25 16:47
 */
@Data
public class TokenKeyDto implements Serializable {
    
    private static final long serialVersionUID = 3009288549097899535L;

    /**
     * 新密钥生效时间，毫秒时间戳
     */
    private long time;

    /**
     * 老密钥不可访问时间，毫秒时间戳
     */
    private long oldKeyNotAccessibleTime;

    /**
     * 老的密钥
     * 为了平滑切换密钥，老的密钥也保留
     */
    private String oldKey;

    /**
     * 新的密钥
     */
    private String newKey;

    /**
     * 是否全量切换到新逻辑，用于线上兼容，false-允许老的token访问，true-不允许老的token访问
     */
    private boolean allSwitch;
}
