package cn.com.duiba.quanyi.center.api.enums.activity.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import cn.com.duiba.quanyi.center.api.enums.user.UserExtCommonKeyEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/4/22 11:40
 */
@AllArgsConstructor
@Getter
public enum ActivityCommonBlackWhiteUserMarkTypeEnum {
    USER_PHONE(1, "用户手机号", UserExtCommonKeyEnum.USER_PHONE),
    BOC_BANK_CLIENT_NUMBER(2, "中行网银客户号", UserExtCommonKeyEnum.BANK_CLIENT_NUMBER),
    BOC_CORE_CLIENT_NUMBER(3, "中行核心客户号", UserExtCommonKeyEnum.CORE_CLIENT_NUMBER),
    ;

    private final Integer type;

    private final String desc;

    private final UserExtCommonKeyEnum extCommonKey;

    private static final Map<Integer, ActivityCommonBlackWhiteUserMarkTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityCommonBlackWhiteUserMarkTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static ActivityCommonBlackWhiteUserMarkTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
