package cn.com.duiba.quanyi.center.api.remoteservice.icbc.jx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.jx.IcbcJxDrawRecordDto;
import cn.com.duiba.quanyi.center.api.param.icbc.jx.IcbcJxDrawRecordSearchParam;
import java.util.List;

/**
 * 用户领取记录表
 * @author kjj mybatis generator 
 * @date 2024-01-10
 */
@AdvancedFeignClient
public interface RemoteIcbcJxDrawRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 用户领取记录集合
     */
    List<IcbcJxDrawRecordDto> selectPage(IcbcJxDrawRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(IcbcJxDrawRecordSearchParam param);

    /**
     * 根据活动期次用户查询
     * @param actId 行方活动ID
     * @param stageId 活动期次
     * @param userId 用户ID
     * @return 订单信息
     */
    IcbcJxDrawRecordDto selectByActStateUser(String actId, String stageId, String userId);

    /**
     * 根据订单号查询
     *  @param orderId 订单号
     * @return 订单信息
     */
    IcbcJxDrawRecordDto selectByOrderId(String orderId);

    /**
     * 根据活动期次用户查询
     * @param goodsOrderNo 兑吧订单号
     * @return 订单信息
     */
    IcbcJxDrawRecordDto selectByGoodsOrderNo(String goodsOrderNo);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户领取记录
     */
    IcbcJxDrawRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户领取记录
     * @return 执行结果
     */
    int insert(IcbcJxDrawRecordDto dto);

    /**
     * 更新
     * @param dto 用户领取记录
     * @return 影响行数
     */
    int update(IcbcJxDrawRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}