package cn.com.duiba.quanyi.center.api.dto.settlement.prepayment;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 项目预付款统计
 * @author mybatis generator
 * @date 2025-03-05
 */
@Data
public class ProjectPrepaymentStatDto implements Serializable {

    private static final long serialVersionUID = 17411533395378038L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 预付款金额
     */
    private Long prepaidAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 已抵扣金额
     */
    private Long deductionAmount;

    /**
     * 退款中金额，单位分
     */
    private Long refundingAmount;

    /**
     * 已退款金额，单位分
     */
    private Long refundedAmount;

    /**
     * 剩余可用金额
     * @return 剩余可用金额
     */
    public Long getSurplusAmount() {
        return getLong(receivedAmount) - getLong(deductionAmount) - getLong(refundingAmount);
    }

    private long getLong(Long num) {
        return num == null ? 0 : num;
    }
}
