package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.PurchaseDemandGoodsStatisticDto;

/**
 * 采购需求商品统计表
 * @author yangyukang
 * @date 2025-11-20 16:12
 */
@AdvancedFeignClient
public interface RemotePurchaseDemandGoodsStatisticService {
     
    /**
     * 根据主键查询
     * @param id 主键
     * @return 采购需求商品统计
     */
    PurchaseDemandGoodsStatisticDto selectById(Long id);

    /**
     * 根据需求商品ID查询
     * @param demandGoodsId 需求商品ID
     * @return 采购需求商品统计
     */
    PurchaseDemandGoodsStatisticDto selectByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据需求商品ID列表查询
     * @param demandGoodsIdList 需求商品ID列表
     * @return 采购需求商品统计列表
     */
    List<PurchaseDemandGoodsStatisticDto> selectByDemandGoodsIdList(List<Long> demandGoodsIdList);
}

