/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.redis;

import cn.com.duiba.quanyi.center.api.redis.AutomaticRenewalRedisLock;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duiba.wolf.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class QyRedisAtomicClient
extends RedisAtomicClient {
    private static final Logger log = LoggerFactory.getLogger(QyRedisAtomicClient.class);
    private final StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
    private static final String COMPARE_AND_DELETE = "if redis.call('get',KEYS[1]) == ARGV[1]\nthen\n    return redis.call('del',KEYS[1])\nelse\n    return 0\nend";

    public QyRedisAtomicClient(RedisTemplate redisTemplate) {
        super(redisTemplate);
        this.stringRedisTemplate.setConnectionFactory(redisTemplate.getConnectionFactory());
        this.stringRedisTemplate.afterPropertiesSet();
    }

    public RedisLock getAutomaticRenewalLock(String key, long expireSeconds, long interval) {
        return this.getAutomaticRenewalLock(key, expireSeconds, 0, 0L, interval);
    }

    public RedisLock getAutomaticRenewalLock(String key, long expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis, long interval) {
        String value = UUIDUtils.createUUID();
        int maxTimes = maxRetryTimes + 1;
        for (int i = 0; i < maxTimes; ++i) {
            Boolean status = (Boolean)this.stringRedisTemplate.execute(connection -> this.setNx(connection, key, value, expireSeconds));
            if (status != null && status.booleanValue()) {
                return new AutomaticRenewalRedisLock(this.stringRedisTemplate, key, value, expireSeconds, interval);
            }
            if (retryIntervalTimeMillis > 0L) {
                try {
                    Thread.sleep(retryIntervalTimeMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
        return null;
    }

    private Boolean setNx(RedisConnection connection, String key, String value, long expireSeconds) {
        return connection.set(key.getBytes(), value.getBytes(), Expiration.seconds((long)expireSeconds), RedisStringCommands.SetOption.ifAbsent());
    }
}

