package cn.com.duiba.quanyi.center.api.param.project;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 项目商品表
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ProjectGoodsSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17294988941268556L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 项目主键, tb_project.id
     */
    private Long projectId;

    /**
     * 项目主键, tb_project.id
     */
    private Set<Long> projectIds;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 采购商品类型
     */
    private Integer purchaseSpuType;

    /**
     * 采购商品类型集合
     */
    private List<Integer> purchaseSpuTypeList;

    /**
     * 结算费率，百分数，支持小数点
     */
    private String settlementRate;

    /**
     * 结算方式，1.按核销结算,2.按订单交易成功,3.按采购结算
     */
    private Integer settlementMethod;

    /**
     * 售价
     */
    private Long settlementPrice;

    /**
     * 审核状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;

    /**
     * 是否启用：1启用 0未启用
     */
    private Integer enableStatus;

    /**
     * 审核状态集合
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private List<Integer> approvalStatusList;

    /**
     * 结算方式集合
     * {@link cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum}
     */
    private List<Integer> settlementMethodList;
}