package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;

/**
 * WxCouponQueryParam
 */
@Data
public class WxCouponQueryParam implements Serializable {

    private static final long serialVersionUID = -5161048170996409136L;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 商品skuId
     */
    private Long skuId;

    /**
     * 面额类型：1-固定，2-不固定
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

}
