package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 订单统计表-日维度
 * @author mybatis generator 
 * @date 2025-02-26
 */
@Data
public class OrderStatDailyDto implements Serializable {
     
    private static final long serialVersionUID = 17405676724893622L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计纬度ID，类型=1-项目ID字符串
     */
    private String statId;

    /**
     * 统计纬度类型：1-项目
     */
    private Integer statType;

    /**
     * 商品类型
     * {@link cn.com.duiba.quanyi.center.api.enums.statistic.DailyOrderStatGoodsTypeEnum}
     */
    private Integer goodsType;

    /**
     * 商品子类型
     */
    private Long subGoodsType;

    /**
     * 容差金额
     */
    private Long toleranceAmount;

    /**
     * 消耗金额
     */
    private Long consumedAmount;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 核销净额
     */
    private Long netVerifiedAmount;

    /**
     * 订单日期
     */
    private LocalDate orderDate;
}