package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.WxApplyBankMultiActivityDto;
import cn.com.duiba.quanyi.center.api.dto.api.WxQueryBankMultiActivityCouponDetailDto;
import cn.com.duiba.quanyi.center.api.param.api.WxApplyBankMultiActivityParam;
import cn.com.duiba.quanyi.center.api.param.api.WxQueryBankMultiActivityCouponDetailParam;

/**
 * @author zzy
 * @create 2025/07/02 11:47
 **/
@AdvancedFeignClient
public interface RemoteWxBankMultiActivityService {

    /**
     * 银行多笔立减报名
     *
     * @param param 报名参数
     * @return 报名结果, 包含失败时的错误信息
     */
    WxApplyBankMultiActivityDto applyBankMultiActivity(WxApplyBankMultiActivityParam param);

    /**
     * 查询银行多笔立减券详情，用户先报名，后可查询
     *
     * @param param 查询参数
     * @return 券详情, 包含失败时的错误信息
     */
    WxQueryBankMultiActivityCouponDetailDto queryBankMultiActivityCouponDetail(WxQueryBankMultiActivityCouponDetailParam param);
}
