package cn.com.duiba.quanyi.center.api.dto.demand;

import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/7/12 21:25
 **/
@Data
public class DemandGoodsAddRecordDetailDto implements Serializable {
    private static final long serialVersionUID = -6218977976856603449L;

    /**
     * 商品名称
     */
    private String purchaseSpuName;

    /**
     * 商品类型
     * @see PurchaseSpuTypeEnum#getType()
     */
    private Integer purchaseSpuType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 面额，单位分（固定面额时必填）
     */
    private Long amount;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 商品数量
     */
    private Long quantity;

    /**
     * 消耗预算
     */
    private Long consumeBudget;

    /**
     * 添加结果
     * true-成功 fail-失败
     */
    private Boolean result;

    /**
     * 添加失败原因
     */
    private String failMsg;
}
