package cn.com.duiba.quanyi.center.api.dto.settlement;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 结算单预结算明细
 * @author mybatis generator 
 * @date 2025-11-11
 */
@Data
public class SettlementPreDetailDto implements Serializable {
     
    private static final long serialVersionUID = 17628315696033146L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 归属项目ID
     */
    private Long projectId;

    /**
     * 归属合同ID
     */
    private Long contractId;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 项目商品ID
     */
    private Long projectGoodsId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 需求商品数量
     */
    private Long demandGoodsQty;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 面额
     */
    private Long amount;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 格式：发票ID_0_金额,发票ID_0_金额
     */
    private String invoiceIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 格式：发票ID_回款ID_金额,发票ID_回款ID_金额
     */
    private String receiveIds;

    /**
     * 格式：refId_金额,refId_金额
     */
    private String refIds;
}