package cn.com.duiba.quanyi.center.api.param.cardsecret;

import java.util.List;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 卡密回退任务分页查询参数
 *
 * @author yangyukang
 * @date 2025-11-15 14:03
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CardSecretRefundTaskPageQueryParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 需求商品ID集合
     */
    private List<Long> demandGoodsIds;

    /**
     * 回退任务状态：1-待处理，2-处理中，3-已完成，4-已失败，5-已取消
     */
    private Integer refundTaskStatus;

    /**
     * 回退任务状态集合
     */
    private List<Integer> refundTaskStatuses;

    /**
     * 审批状态
     */
    private Integer approvalStatus;

    /**
     * 是否结算：0-未结算，1-已结算
     */
    private Integer isSettled;

    /**
     * 发起人SSO用户ID
     */
    private Long operatorSsoId;

    /**
     * 审批流程实例ID
     */
    private Long workflowInstanceId;
}

