/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;

public class QyDateTimeUtils {
    private QyDateTimeUtils() {
    }

    public static Date getMondayOfPreWeek() {
        return QyDateTimeUtils.convertLocalDateToDate(LocalDate.now().minusWeeks(1L).with(DayOfWeek.MONDAY));
    }

    public static Date getMondayOfThisWeek() {
        return QyDateTimeUtils.convertLocalDateToDate(LocalDate.now().with(DayOfWeek.MONDAY));
    }

    public static Date getSundayOfPreWeek() {
        return QyDateTimeUtils.convertLocalDateToDate(LocalDate.now().minusWeeks(1L).with(DayOfWeek.SUNDAY));
    }

    public static Date getMondayOfNextWeek() {
        return QyDateTimeUtils.convertLocalDateToDate(LocalDate.now().plusWeeks(1L).with(DayOfWeek.MONDAY));
    }

    public static Date convertLocalDateToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate convertDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date calculateTime(int weekOfDay, Date time) {
        String zoneId = "Asia/Shanghai";
        ZonedDateTime zonedDateTime = time.toInstant().atZone(ZoneId.of(zoneId));
        LocalDate currentDate = LocalDate.now(ZoneId.of(zoneId));
        LocalDate targetDate = currentDate.with(TemporalAdjusters.nextOrSame(DayOfWeek.of(weekOfDay)));
        if (targetDate.isBefore(currentDate)) {
            targetDate = targetDate.plusWeeks(1L);
        }
        ZonedDateTime targetZonedDateTime = targetDate.atTime(zonedDateTime.toLocalTime()).atZone(ZoneId.of(zoneId));
        return Date.from(targetZonedDateTime.toInstant());
    }

    public static String parse(String date, String oldFormat, String newFormat) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern(oldFormat);
        LocalDateTime dateTime = LocalDateTime.parse(date, inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern(newFormat);
        return dateTime.format(outputFormatter);
    }

    public static int getWeekOfDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        int today = calendar.get(7);
        return today == 1 ? 7 : today - 1;
    }

    public static Date getDayEndTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getNowAddHours(int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, amount);
        return calendar.getTime();
    }

    public static Date removeMillisecond(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getYesterday(String pattern) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(pattern);
        LocalDate lastDayDate = LocalDate.now().minusDays(1L);
        return lastDayDate.format(fmt);
    }

    public static Date getDate(String date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate localDate = LocalDate.parse(date, dateTimeFormatter);
        return QyDateTimeUtils.convertLocalDateToDate(localDate);
    }

    public static String getStr(Date date, String formatPattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        return format.format(date);
    }

    public static long daysBetween(Date startDate, Date endDate) {
        return DateUtil.between((Date)startDate, (Date)endDate, (DateUnit)DateUnit.DAY, (boolean)true);
    }

    public static Date addDays(Date availableBeginTime, Integer consumeStockDays) {
        return DateUtil.offsetDay((Date)availableBeginTime, (int)consumeStockDays);
    }

    public static String getCurrentTime() {
        return DateUtil.now();
    }

    public static Date getCurrentMonthEndTime(Date date) {
        return QyDateTimeUtils.getDayEndTime((Date)DateUtil.endOfMonth((Date)date));
    }

    public static Date getHourlyDate() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime truncatedTime = now.withMinute(0).withSecond(0).withNano(0);
        return Date.from(truncatedTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getSundayOfThisWeek() {
        return QyDateTimeUtils.getDayEndTime(QyDateTimeUtils.convertLocalDateToDate(LocalDate.now().with(DayOfWeek.SUNDAY)));
    }
}

