package cn.com.duiba.quanyi.center.api.enums.bigdata;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenyongkun
 */

public enum QueryOperatorTypeEnum {

    //维度操作符
    IN(" in (${value}) ", true, "等于单个值或者多个值"),

    NOT_IN(" not in (${value}) ", true, "不等于单个值或者多个值"),

    IS_NULL(" is null ", false, "字段为空"),

    IS_NOT_NULL(" is not null ", false, "字段不为空"),

    BETWEEN(" between ${value} ", true, "在某个区间"),


    //指标操作符
    GT(" > ", true, "大于"),

    GE(" >= ", true, "大于等于"),

    EQ(" = ", true, "等于"),

    LT(" < ", true, "小于"),

    LE(" <= ", true, "小于等于")


    ;

    //需要拼接的sql代码段
    private final String sqlSegment;

    //是否需要传值
    private final Boolean needValue;

    //解释说明
    private final String desc;

    //枚举集合
    private static final Map<String, QueryOperatorTypeEnum> enumMap = new HashMap<>();

    QueryOperatorTypeEnum(String sqlSegment, Boolean needValue, String desc) {
        this.sqlSegment = sqlSegment;
        this.needValue = needValue;
        this.desc = desc;
    }

    public String getSqlSegment() {
        return sqlSegment;
    }

    public Boolean getNeedValue() {
        return needValue;
    }

    public String getDesc() {
        return desc;
    }

    public static Map<String, QueryOperatorTypeEnum> getEnumMap() {
        return enumMap;
    }

    static {
        QueryOperatorTypeEnum[] values = QueryOperatorTypeEnum.values();
        for (QueryOperatorTypeEnum value : values) {
            enumMap.put(value.toString(), value);
        }
    }

}
