package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 用户角色枚举
 * @author yangyukang
 * @date 2024-12-19
 */
@Getter
@AllArgsConstructor
public enum UserRoleEnum {
    CUSTOMER_MANAGER(1, "客户经理"),
    ADMIN(2, "管理员"),
    ;
    
    private final Integer code;
    
    private final String desc;
    
    /**
     * 根据代码获取枚举
     * @param code 角色代码
     * @return 用户角色枚举
     */
    public static UserRoleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (UserRoleEnum userRole : values()) {
            if (userRole.getCode().equals(code)) {
                return userRole;
            }
        }
        return null;
    }
    
    /**
     * 判断是否为有效的角色代码
     * @param code 角色代码
     * @return 是否有效
     */
    public static boolean isValidCode(Integer code) {
        return getByCode(code) != null;
    }
} 