package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 多选N维度枚举
 * @author yangyukang
 * @date 2025-01-20
 */
@Getter
@AllArgsConstructor
public enum MultiSelectNDimensionEnum {

    /**
     * 不限制
     */
    NO_LIMIT(0, "不限制"),

    /**
     * 日
     */
    DAY(1, "日"),

    /**
     * 自然周
     */
    WEEK(2, "自然周"),

    /**
     * 自然月
     */
    MONTH(3, "自然月"),

    /**
     * 自然季度
     */
    QUARTER(4, "自然季度"),

    /**
     * 永久
     */
    PERMANENT(5, "永久"),

    /**
     * 自定义
     */
    CUSTOM(6, "自定义"),
    ;

    private final Integer code;

    private final String desc;

    /**
     * 根据code获取枚举
     * @param code 编码
     * @return 枚举
     */
    public static MultiSelectNDimensionEnum getByCode(Integer code) {
        if (code == null) {
            return PERMANENT;
        }
        for (MultiSelectNDimensionEnum dimensionEnum : values()) {
            if (dimensionEnum.getCode().equals(code)) {
                return dimensionEnum;
            }
        }
        return PERMANENT;
    }
}
